<?php
defined('PF_VERSION') OR exit('Access denied');
$current = isset($_GET['current']) ? (int) $_GET['current'] : '';
$published_date = print_date($post->post_published_date);
$unpublished_date = print_date($post->post_unpublished_date);
?>
<div class="row pull-right btnTop">
    <div class="col-md-12">
        <?php
        add_toolbar_button(form_button("<i class='fa fa-check'></i> " . __('Save', 'post'), array('class' => 'btn btn-primary btnSave')));
        add_toolbar_button(form_button(" " . __('Cancel', 'post'), array('onclick' => "window.location='" . admin_url(array('admin-page' => 'post', 'sub_page' => 'post', 'current' => $current), false) . "'", 'class' => 'btn btn-default')));
        ?>
    </div>
</div><!--end button-->

<div class="hidden" id="messageErrorJS">
    <ul>
        <li class="confirmDeleteTag"><?php echo __('Are you sure you want to delete?', 'post'); ?></li>
        <li class="errorOperation"><?php echo __('An error has occurred. Please try again', 'post'); ?></li>
        <li class="errorChoiceTag"><?php echo __('You must select at least one tag', 'post'); ?></li>
    </ul>
</div>

<div class="row">
    <div class="col-sm-12">
        <div class="panel panel-default">
            <div class="panel-heading">
                <h3 class="panel-title">
                    <i class="fa fa-list"></i> <?php echo __('Edit Post', 'post'); ?>
                </h3>
            </div>
            <div class="panel-body">
                <form action="<?php echo admin_url('&act=edit') ?>" class="form-horizontal" method="post" role="form">
                    <table class="table table-bordered form">
                        <colgroup>
                            <col span="1" class="col-md-2 header">
                            <col span="1" class="col-md-4">
                            <col span="1" class="col-md-2 header">
                            <col span="1" class="col-md-4">
                        </colgroup>
                        <tr>
                            <td>
                                <label class="control-label"><?php echo __('Title', 'post') ?> <span>*</span></label>
                            </td>
                            <td colspan="3" class="<?php echo state_validator('title', $validated); ?>">
                                <?php
                                echo form_input(array('name' => 'title', 'class' => 'form-control', 'id' => 'title', 'value' => $post->post_title, 'tabindex' => 1));
                                echo form_input(array('name' => 'id', 'type' => 'hidden', 'value' => $post->id));
                                echo form_input(array('name' => 'current', 'type' => 'hidden', 'value' => $current));
                                echo get_token_input();
                                echo alert_error_validator('title', $validated);
                                ?>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <label class="control-label"><?php echo __('Category', 'post') ?> <span>*</span></label>
                            </td>
                            <td class="<?php echo state_validator('category', $validated); ?>">
                                <select name="category" class="form-control" tabindex="2">
                                    <?php
                                    if (count($categories)):
                                        foreach ($categories as $category):
                                            ?>
                                            <option value="<?php echo $category[0]; ?>" <?php echo ($category[0] == $post->post_category) ? 'selected=selected' : ''; ?>><?php echo $category[1]; ?></option>
                                            <?php
                                        endforeach;
                                    endif;
                                    echo alert_error_validator('category', $validated);
                                    ?>
                                </select>
                            </td>

                            <td>
                                <label for="Published date" class="control-label"><?php echo __('Published date', 'post'); ?></label>
                            </td>
                            <td class="<?php echo state_validator('published_date', $validated); ?>">
                                <div class="input-group date" id="publishedDate" data-date-format="YYYY-MM-DD HH:mm:ss">
                                    <?php
                                    echo form_input(array('name' => 'published_date', 'class' => 'form-control', 'value' => $published_date, 'tabindex' => 4));
                                    ?>
                                    <span class="input-group-addon"><span class="glyphicon glyphicon-calendar"></span>
                                    </span>
                                </div>
                                <?php echo alert_error_validator('published_date', $validated); ?>
                            </td>
                        </tr>


                        <tr>
                            <td>
                                <label class="control-label"><?php echo __('Status', 'post') ?> <span>*</span></label>
                            </td>
                            <?php if (current_user('user-group') < 4) : ?>
                                <td class="<?php echo state_validator('status', $validated); ?>">
                                    <?php
                                    echo form_dropdown('status', $status, $post->post_status, "class='form-control' tabindex='3'");
                                    echo alert_error_validator('status', $validated);
                                    ?>
                                </td>
                            <?php else: ?>
                                <td><?php echo $post->post_status == 1 ? __('Published', 'post') : __('Unpublished', 'post') ?></td>
                            <?php endif; ?>
                            <td>
                                <label for="unpublished_date" class="control-label"><?php echo __('Unpublished date', 'post'); ?></label>
                            </td>
                            <td class="<?php echo state_validator('unpublished_date', $validated); ?>">
                                <div class="input-group date" id="unpublishedDate" data-date-format="YYYY-MM-DD HH:mm:ss">
                                    <?php
                                    echo form_input(array('name' => 'unpublished_date', 'class' => 'form-control', 'value' => $unpublished_date, 'tabindex' => 5));
                                    ?>
                                    <span class="input-group-addon"><span class="glyphicon glyphicon-calendar"></span>
                                    </span>
                                </div>
                                <?php echo alert_error_validator('unpublished_date', $validated); ?>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <label class="control-label"><?php echo __('Thumbnail', 'post') ?></label>
                            </td>
                            <td colspan="3" class="<?php echo state_validator('thumbnail', $validated); ?>">
                                <div class="input-group">
                                    <?php
                                    echo form_input(array('name' => 'thumbnail', 'class' => 'form-control', 'id' => 'thumbnail', 'value' => e($post->post_thumbnail)));
                                    echo alert_error_validator('thumbnail', $validated);
                                    ?>
                                    <span class="input-group-addon">
                                        <a class="fa fa-picture-o boxGetFile" id="btnChoiceThumbnail" href="<?php echo site_url(false) . RELATIVE_PATH . '/admin/plugins/media/filemanager/dialog.php?type=1&field_id=thumbnail'; ?>"></a>
                                    </span>
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <label class="control-label"><?php echo __('Content', 'post') ?> <span>*</span></label>
                            </td>
                            <td colspan="3" class="<?php echo state_validator('content', $validated); ?>">
                                <?php
                                echo form_editor(array('name' => 'content', 'class' => 'form-control', 'rows' => 10, 'style' => 'height:400px', 'tabindex' => 6), e($post->post_content));
                                echo alert_error_validator('content', $validated);
                                ?>
                            </td>
                        </tr>

                        <tr>
                            <td>
                                <label class="control-label"><?php echo __('Tags', 'post') ?></label>
                            </td>
                            <td colspan="3" class="<?php echo state_validator('tags', $validated); ?>">
                                <?php echo form_input(array('name' => 'tags', 'data-role' => 'tagsinput', 'placeholder' => __('Add tags', 'post'), 'value' => e($tags))); ?>
                                <button type="button" id="btnTagsManager" class="btn btn-warning btn-sm"><?php echo __('Tags manager', 'post') ?></button>
                                <p class="help-block">
                                    <?php
                                    printf(__('Notice: You are allowed to use up to %s tag and you can add multiple tags at once. Each tag separated by a comma', 'post'), $max_tags);
                                    ?>
                                </p>
                            </td>
                        </tr>
                    </table>
                </form>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="tagsManager" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <form class="form-horizontal" role="form" method="post" accept-charset="utf-8">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                    <h4 class="modal-title" id="myModalLabel"><?php echo __('Tags manager', 'post'); ?></h4>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-12">
                            <table class="table table-bordered table-tags">
                                <thead>
                                <th></th>
                                <th><?php echo __('Tags', 'post'); ?></th>
                                <th><?php echo __('Action', 'post'); ?></th>
                                </thead>
                                <tbody>

                                </tbody>
                            </table>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-12">
                            <div class="pull-right" id="paginationTag">

                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo __('Close', 'post'); ?></button>
                    <button type="button" class="btn btn-primary" id="btnChoiceTags"><?php echo __('Choose Tags', 'post'); ?></button>
                </div>
            </form>
        </div>
    </div>
</div><!--end modal -->

<?php
require_once ABSPATH . '/plugins/contactform/views/particals/element.php';
require_once ABSPATH . '/includes/common/plugin/views/alert.php';
